<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 07.01.14 10:13
 */

namespace VM\ApiBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class TokensRemoverCommand extends ContainerAwareCommand
{

    protected function configure()
    {
        $this
            ->setName('api:tokens:remove')
            ->setDescription('Usuwa przestarzałe tokeny')
            ->addOption('delay', null, InputOption::VALUE_REQUIRED, 'Różnica czasu wyrażona w sekundach od chwili bieżącej do której mają zostać usunięte tokeny', 3600)
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $delay = $input->getOption('delay');

        $DateTime = new \DateTime();
        $DateTime->sub(new \DateInterval('PT' . $delay . 'S'));

        $output->writeln('Usuwam tokeny, których data ważności wygasła przed: <info>' . $DateTime->format("Y-m-d H:i:s") . '</info>');

        $sql = $this->getContainer()->get('doctrine')->getManager()->createQuery('DELETE FROM VMApiBundle:UserToken u WHERE u.expireAt <= :expireAt')
            ->setParameter('expireAt', $DateTime->format("Y-m-d H:i:s"));
        ;
        $result = $sql->execute();

        $output->writeln('Usunięto <info>' . $result . '</info> tokeny');
    }
} 